using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Microsoft.Win32;

namespace DateWnd
{
	static class Program
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[MTAThread]
		static void Main(string[] args)
		{
			bool	isOptions	= false;

			// there are times that the Options dialog needs to be shown
			// when the application is not loaded.  In this case, Dashboard
			// will call the application with a command line of Options [viewNbr]
			// so we parse them out and launch the Options.
			if (args.Length	> 0)
			{
				if (args[0]	== "Options")
				{
					int	viewNumber	= 0;

					if (args.Length	> 1)
					{
						viewNumber	= Convert.ToInt32(args[1]);

						if (viewNumber	< 0)
						{
							viewNumber	= 0;
						}
					}

					ShowOptions(viewNumber);
					isOptions	= true;
				}
			}

			// if the Options were not shown then go ahead and launch the
			// program normally
			if (!isOptions)
			{
				Application.Run(new DateWnd());
			}
		}


		/// <summary>
		/// Display the Options dialog and pull the settings for the requested view.
		/// </summary>
		/// <param name="viewNumber"></param>
		static public void ShowOptions(int viewNumber)
		{
			Options		dlgOptions	= new Options();
			string		dateName	= "DateFormat";
			string		timeName	= "TimeFormat";

			// make Options view-specific but with normal defaults passed in if value doesn't exist
			if (viewNumber	> 0)
			{
				dateName	+= viewNumber.ToString();
				timeName	+= viewNumber.ToString();
			}

			// read the settings from the registry
			dlgOptions.DateFormat	= (string) Registry.GetValue("HKEY_CURRENT_USER\\SOFTWARE\\SnoopSoft\\Date\\", dateName, "dddd, MMMM dd, yyyy");
			dlgOptions.TimeFormat	= (string) Registry.GetValue("HKEY_CURRENT_USER\\SOFTWARE\\SnoopSoft\\Date\\", timeName, "hh:mm tt");

			dlgOptions.ShowDialog();

			// save the new settings to the Registry
			Registry.SetValue("HKEY_CURRENT_USER\\SOFTWARE\\SnoopSoft\\Date\\", dateName, dlgOptions.DateFormat);
			Registry.SetValue("HKEY_CURRENT_USER\\SOFTWARE\\SnoopSoft\\Date\\", timeName, dlgOptions.TimeFormat);
		}
	}
}