using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.Drawing.Imaging;

namespace DateWnd
{
	public partial class Options : Form
	{
		private string	m_strDateFormat	= "";
		private string	m_strTimeFormat	= "";

		public	string	DateFormat
		{	get { return m_strDateFormat; }
			set { m_strDateFormat = value;}
		}

		public	string	TimeFormat
		{	get { return m_strTimeFormat; }
			set { m_strTimeFormat = value;}
		}

		public Options()
		{
			InitializeComponent();
		}

		private void OnLoad(object sender, EventArgs e)
		{
			m_DateFormat.Text	= m_strDateFormat;
			m_TimeFormat.Text	= m_strTimeFormat;
		}


		private void OnClosing(object sender, CancelEventArgs e)
		{
			m_strDateFormat	= m_DateFormat.Text;
			m_strTimeFormat	= m_TimeFormat.Text;

			m_pictureIcon.Hide();
		}

		private void OnPaint(object sender, PaintEventArgs e)
		{
			Assembly		asm			= Assembly.GetExecutingAssembly();
			string			iconName	= asm.GetName().Name + ".Icon" + e.Graphics.DpiX.ToString() + ".gif";
			Bitmap			icon		= new Bitmap(asm.GetManifestResourceStream(iconName));
			ImageAttributes	iaIcon		= new ImageAttributes();
			Rectangle		rImage		= new Rectangle(m_pictureIcon.Left, m_pictureIcon.Top, icon.Width, icon.Height);

			// set bitmap transparency to upper left pixel color
			iaIcon.SetColorKey(icon.GetPixel(0,0), icon.GetPixel(0,0));

			e.Graphics.DrawImage(icon, rImage, 0, 0, icon.Width, icon.Height, GraphicsUnit.Pixel, iaIcon);
		}
	}
}